from libdebug import debugger
from string import ascii_letters, digits

def callback(_, __):
    pass

def on_enter_nanosleep(t, _):
    t.syscall_arg0 = 0
    t.syscall_arg1 = 0
    t.syscall_arg2 = 0
    t.syscall_arg3 = 0

d = debugger("main", escape_antidebug=True)

alphabet = ascii_letters + digits + "_{}"

for c in alphabet:
    r = d.run()
    bp = d.breakpoint(0x13e1, hardware=True, callback=callback, file="binary")
    d.handle_syscall("clock_nanosleep", on_enter=on_enter_nanosleep)
    d.pprint_syscalls = True
    d.cont()

    r.sendline(c.encode())

    d.wait()
    
    d.kill()

    print(c, bp.hit_count)

    if bp.hit_count > 0:
        print('Found:', c)
        break